/*
** This routine worries a lot about how to clean up the screen after
** a window has re-sized, moved, or disappeared. Since there can be
** many overlapping windows, the task is not trivial. The trick used
** is to define a list of rectangles formed wherever the window is
** visible, and then to refresh each rectangle  (using the clipping
** functions) wherever it overlaps the dirty rectangle passed to us.
** rc_intersect returns TRUE if there is an overlap, and it puts the
** overlap into its second argument.
** The function wind_get() is used to get the FIRST rectangle in the
** list, then used again in a loop to get each NEXT rectangle.
*/

# include <obdefs.h>
# include <gemdefs.h>

do_redraw(xc,yc,wc,he,whand,vw)
int xc, yc, wc, he, whand, vw; {
	
		int clip[4];
		GRECT tl, t2;
		
		hide_mouse();
		wind_update(1);
		t2.g_x = xc;
		t2.g_y = yc;
		t2.g_w = wc;
		t2.g_h = hc;

		wind_get(whand,WF_FIRSTXYWH,&t1.g_x,&t1.g_y,&t1.g_w,&t1.g_h);
		while (tl.g_w && tl.g_h) {
			if (rc_intersect(&t2,&tl)) {
				clip[0] = t1.g_x;
				clip[1] = t1.g_y;
				clip[2] = t1.g_x + t1.g_w - 1;
				clip[3] = t1.g_y + t1.g_h - 1;
				vs_clip (vw,1,clip);
				just_draw (whand,&t1.g_x,&t1.g_y,&t1.g_w,&t1.g_h, vw);
				}
			wind_get(whand,WF_NEXTXYWH,&t1.g_x,&t1.g_y,&t1.g_w,&t1.g_h); 
			}
	wind_update(0);
	show_mouse();
}